/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.action;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.IUIElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.util.ColorUtils;
import nl.lxtreme.ols.util.NumberUtils;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.StandardActionFactory;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.EnumItemRenderer;
import nl.lxtreme.ols.util.swing.validation.JComponentInputVerifier;

public class EditSignalElementPropertiesAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final IUIElement element;
    private final Point dialogLocation;
    private final SignalDiagramController controller;

    public EditSignalElementPropertiesAction(SignalDiagramController aController, IUIElement aElement, Point aChannelLocation) {
        super("Element Properties");
        this.controller = aController;
        this.element = aElement;
        this.dialogLocation = new Point(aChannelLocation.x + 15, aChannelLocation.y + 5);
        this.setEnabled(this.element != null);
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        EditPropertiesDialog dialog = new EditPropertiesDialog(SwingComponentUtils.getOwningWindow((AWTEvent)aEvent), this.element);
        dialog.setLocation(this.dialogLocation);
        if (dialog.showDialog()) {
            SignalElement signalElement;
            this.element.setLabel(dialog.getLabel());
            this.element.setColor(dialog.getColor());
            this.element.setHeight(dialog.getElementHeight());
            if (this.element instanceof SignalElement && (signalElement = (SignalElement)this.element).isDigitalSignal()) {
                signalElement.setSignalHeight(dialog.getSignalHeight());
                signalElement.setSignalAlignment(dialog.getSignalAlignment());
            }
            this.controller.revalidateAll();
        }
    }

    static final class SignalAlignmentComboBoxRenderer
    extends EnumItemRenderer<SignalDiagramModel.SignalAlignment> {
        private static final long serialVersionUID = 1L;

        SignalAlignmentComboBoxRenderer() {
        }

        protected String getDisplayValue(SignalDiagramModel.SignalAlignment aValue) {
            switch (aValue) {
                case BOTTOM: {
                    return "Bottom";
                }
                case TOP: {
                    return "Top";
                }
                case CENTER: {
                    return "Center";
                }
            }
            return super.getDisplayValue((Enum)aValue);
        }
    }

    static final class JColorEditor
    extends JTextField {
        private static final long serialVersionUID = 1L;
        private volatile Color color;
        private volatile boolean readOnly;

        public JColorEditor(Color aColor) {
            super("");
            this.setEditable(false);
            this.setColor(aColor);
        }

        public JColorEditor(String aColor) {
            super("");
            this.setEditable(false);
            this.setColor(aColor);
        }

        @Override
        public void addNotify() {
            try {
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent aEvent) {
                        if (!JColorEditor.this.isReadOnly() && aEvent.getClickCount() == 2) {
                            JColorEditor.this.showEditDialog();
                        }
                    }
                });
            }
            finally {
                super.addNotify();
            }
        }

        public final Color getColor() {
            return this.color;
        }

        public final boolean isReadOnly() {
            return this.readOnly;
        }

        public final void setColor(Color aColor) {
            this.color = aColor;
            this.setBackground(this.color);
            this.setToolTipText("#".concat(ColorUtils.toHexString((Color)aColor)));
        }

        public final void setColor(String aColor) {
            this.setColor(ColorUtils.parseColor((String)aColor));
        }

        public final void setReadOnly(boolean aReadOnly) {
            this.readOnly = aReadOnly;
        }

        protected void showEditDialog() {
            Color result = JColorChooser.showDialog(this, "Edit color", this.getColor());
            if (result != null) {
                this.setColor(result);
            }
        }
    }

    static final class EditPropertiesDialog
    extends JDialog
    implements StandardActionFactory.StatusAwareCloseableDialog {
        private static final long serialVersionUID = 1L;
        private final String defaultLabel;
        private final Color defaultColor;
        private final int defaultHeight;
        private final int defaultSignalHeight;
        private final SignalDiagramModel.SignalAlignment defaultAlignment;
        private JTextField labelEditor;
        private JColorEditor colorEditor;
        private JTextField heightEditor;
        private JTextField signalHeightEditor;
        private JComboBox signalAlignmentEditor;
        boolean dialogResult = false;

        public EditPropertiesDialog(Window aParent, IUIElement aElement) {
            super(aParent, Dialog.ModalityType.APPLICATION_MODAL);
            this.setResizable(false);
            this.defaultLabel = aElement.getLabel();
            this.defaultColor = aElement.getColor();
            this.defaultHeight = aElement.getHeight();
            if (aElement instanceof SignalElement) {
                this.defaultSignalHeight = ((SignalElement)aElement).getSignalHeight();
                this.defaultAlignment = ((SignalElement)aElement).getSignalAlignment();
            } else {
                this.defaultSignalHeight = 0;
                this.defaultAlignment = null;
            }
            this.initDialog(aElement);
        }

        private static String getTitle(IUIElement aElement) {
            if (aElement instanceof SignalElement) {
                SignalElement signalElement = (SignalElement)aElement;
                if (signalElement.isDigitalSignal()) {
                    return "Edit channel properties";
                }
                if (signalElement.isAnalogSignal()) {
                    return "Edit scope properties";
                }
                if (signalElement.isGroupSummary()) {
                    return "Edit group summary properties";
                }
            }
            return "Edit signal group properties";
        }

        public void close() {
            this.setVisible(false);
            this.dispose();
        }

        public Color getColor() {
            return this.colorEditor.getColor();
        }

        public int getElementHeight() {
            int defaultValue = UIManager.getInt("ols.channel.height");
            return NumberUtils.safeParseInt((String)this.heightEditor.getText(), (int)defaultValue);
        }

        public String getLabel() {
            return this.labelEditor.getText();
        }

        public SignalDiagramModel.SignalAlignment getSignalAlignment() {
            SignalDiagramModel.SignalAlignment result = (SignalDiagramModel.SignalAlignment)((Object)this.signalAlignmentEditor.getSelectedItem());
            if (result == null) {
                result = SignalDiagramModel.SignalAlignment.valueOf(UIManager.getString("ols.signal.alignment.enum"));
            }
            return result;
        }

        public int getSignalHeight() {
            int defaultValue = UIManager.getInt("ols.digitalsignal.height");
            return NumberUtils.safeParseInt((String)this.signalHeightEditor.getText(), (int)defaultValue);
        }

        public boolean setDialogStatus(StandardActionFactory.DialogStatus aStatus) {
            boolean isOkButton = aStatus == StandardActionFactory.DialogStatus.OK;
            String text = this.labelEditor.getText();
            if (isOkButton && (text == null || "".equals(text))) {
                JOptionPane.showMessageDialog(this.getParent(), "No label defined!", "Invalid properties", 0);
                return false;
            }
            this.dialogResult = isOkButton;
            return true;
        }

        public boolean showDialog() {
            this.dialogResult = false;
            this.setVisible(true);
            return this.dialogResult;
        }

        protected void applyDefaultProperties() {
            this.labelEditor.setText(this.defaultLabel);
            this.colorEditor.setColor(this.defaultColor);
            this.heightEditor.setText("" + this.defaultHeight);
            this.signalHeightEditor.setText("" + this.defaultSignalHeight);
            this.signalAlignmentEditor.setSelectedItem((Object)this.defaultAlignment);
        }

        private void initDialog(IUIElement aElement) {
            this.setTitle(EditPropertiesDialog.getTitle(aElement));
            final JButton okButton = StandardActionFactory.createOkButton();
            JButton cancelButton = StandardActionFactory.createCancelButton();
            JLabel labelEditorLabel = SwingComponentUtils.createRightAlignedLabel((String)"Label");
            this.labelEditor = new JTextField(aElement.getLabel(), 10);
            this.labelEditor.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent aEvent) {
                    this.updateOkButton(aEvent);
                }

                @Override
                public void insertUpdate(DocumentEvent aEvent) {
                    this.updateOkButton(aEvent);
                }

                @Override
                public void removeUpdate(DocumentEvent aEvent) {
                    this.updateOkButton(aEvent);
                }

                private void updateOkButton(DocumentEvent aEvent) {
                    String text = EditPropertiesDialog.this.labelEditor.getText();
                    okButton.setEnabled(text != null && !"".equals(text.trim()));
                }
            });
            JLabel colorEditorLabel = SwingComponentUtils.createRightAlignedLabel((String)"Color");
            this.colorEditor = new JColorEditor(aElement.getColor());
            JLabel heightEditorLabel = SwingComponentUtils.createRightAlignedLabel((String)"Height");
            this.heightEditor = new JTextField("" + aElement.getHeight(), 10);
            this.heightEditor.setInputVerifier((InputVerifier)JComponentInputVerifier.create(Integer.class, (String)"Invalid height! Must be a postive whole number."));
            JLabel signalHeightEditorLabel = SwingComponentUtils.createRightAlignedLabel((String)"Signal height");
            this.signalHeightEditor = new JTextField("" + this.defaultSignalHeight, 10);
            this.signalHeightEditor.setInputVerifier((InputVerifier)JComponentInputVerifier.create(Integer.class, (String)"Invalid height! Must be a postive whole number."));
            JLabel signalAlignmentEditorLabel = SwingComponentUtils.createRightAlignedLabel((String)"Signal alignment");
            this.signalAlignmentEditor = new JComboBox<SignalDiagramModel.SignalAlignment>(SignalDiagramModel.SignalAlignment.values());
            this.signalAlignmentEditor.setRenderer(new SignalAlignmentComboBoxRenderer());
            this.signalAlignmentEditor.setSelectedItem((Object)this.defaultAlignment);
            JButton resetButton = new JButton("Reset to defaults");
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvent) {
                    EditPropertiesDialog.this.applyDefaultProperties();
                }
            });
            JPanel resetButtonPanel = new JPanel();
            resetButtonPanel.add((Component)resetButton, "After");
            JPanel editorPane = new JPanel(new SpringLayout());
            editorPane.add(labelEditorLabel);
            editorPane.add(this.labelEditor);
            editorPane.add(colorEditorLabel);
            editorPane.add(this.colorEditor);
            editorPane.add(heightEditorLabel);
            editorPane.add(this.heightEditor);
            if (aElement instanceof SignalElement && ((SignalElement)aElement).isDigitalSignal()) {
                editorPane.add(signalHeightEditorLabel);
                editorPane.add(this.signalHeightEditor);
                editorPane.add(signalAlignmentEditorLabel);
                editorPane.add(this.signalAlignmentEditor);
            }
            editorPane.add(new JLabel(""));
            editorPane.add(resetButtonPanel);
            SpringLayoutUtils.makeEditorGrid((Container)editorPane, (int)10, (int)10);
            JComponent buttonPane = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{okButton, cancelButton});
            JPanel contentPane = new JPanel(new BorderLayout(4, 4));
            contentPane.add((Component)editorPane, "Center");
            contentPane.add((Component)buttonPane, "Last");
            this.setContentPane(contentPane);
            this.getRootPane().setDefaultButton(okButton);
            this.pack();
        }
    }
}

