/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramComponent;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;

public class SetSignalElementVisibilityAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final SignalElement signalElement;
    private final SignalDiagramController controller;

    public SetSignalElementVisibilityAction(SignalDiagramController aController, SignalElement aSignalElement) {
        this.signalElement = aSignalElement;
        this.controller = aController;
        this.putValue("Name", SetSignalElementVisibilityAction.getLabel(aSignalElement.getType(), aSignalElement.isEnabled()));
    }

    private static String getLabel(SignalElement.SignalElementType aType, boolean aVisible) {
        String suffix;
        String prefix;
        String string = prefix = aVisible ? "Hide" : "Show";
        if (aType == SignalElement.SignalElementType.DIGITAL_SIGNAL) {
            prefix = aVisible ? "Disable" : "Enable";
            suffix = "digital signal";
        } else if (aType == SignalElement.SignalElementType.ANALOG_SIGNAL) {
            suffix = "analog signal";
        } else if (aType == SignalElement.SignalElementType.GROUP_SUMMARY) {
            suffix = "group summary";
        } else {
            throw new InternalError("Unknown signal element?!");
        }
        return String.format("%s %s", prefix, suffix);
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        this.signalElement.setEnabled(!this.signalElement.isEnabled());
        if (this.signalElement.isDigitalSignal()) {
            this.getSignalDiagram().repaintSignalElement(this.signalElement);
        } else {
            this.controller.revalidateAll();
        }
    }

    private SignalDiagramComponent getSignalDiagram() {
        return this.controller.getSignalDiagram();
    }
}

