/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ElementGroup;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;

public class SetSignalGroupVisibilityAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final ElementGroup group;
    private final SignalDiagramController controller;
    private final SignalElement.SignalElementType elementType;

    public SetSignalGroupVisibilityAction(SignalDiagramController aController, ElementGroup aGroup, SignalElement.SignalElementType aType) {
        boolean visible;
        String suffix;
        this.group = aGroup;
        this.controller = aController;
        this.elementType = aType;
        if (aType == SignalElement.SignalElementType.DIGITAL_SIGNAL) {
            suffix = "digital signals";
            visible = this.group.isShowDigitalSignals();
        } else if (aType == SignalElement.SignalElementType.ANALOG_SIGNAL) {
            suffix = "analog signal";
            visible = this.group.isShowAnalogSignal();
        } else if (aType == SignalElement.SignalElementType.GROUP_SUMMARY) {
            suffix = "group summary";
            visible = this.group.isShowGroupSummary();
        } else {
            throw new InternalError("Unknown signal element?!");
        }
        String prefix = visible ? "Hide" : "Show";
        this.putValue("Name", prefix.concat(" ").concat(suffix));
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        if (this.elementType == SignalElement.SignalElementType.DIGITAL_SIGNAL) {
            this.group.setShowDigitalSignals(!this.group.isShowDigitalSignals());
        } else if (this.elementType == SignalElement.SignalElementType.ANALOG_SIGNAL) {
            this.group.setShowAnalogSignal(!this.group.isShowAnalogSignal());
        } else if (this.elementType == SignalElement.SignalElementType.GROUP_SUMMARY) {
            this.group.setShowGroupSummary(!this.group.isShowGroupSummary());
        }
        this.controller.revalidateAll();
    }
}

