/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.laf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import nl.lxtreme.ols.client.signaldisplay.model.ChannelLabelsViewModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ElementGroup;
import nl.lxtreme.ols.client.signaldisplay.signalelement.IUIElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.view.ChannelLabelsView;
import nl.lxtreme.ols.util.ColorUtils;

public class ChannelLabelsUI
extends ComponentUI {
    private static RenderingHints createRenderingHints() {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        return hints;
    }

    @Override
    public Dimension getPreferredSize(JComponent aComponent) {
        ChannelLabelsView view = (ChannelLabelsView)aComponent;
        ChannelLabelsViewModel model = view.getModel();
        int height = 0;
        int width = 0;
        if (model.hasData()) {
            height = model.getPreferredHeight();
            width = model.getPreferredWidth();
        }
        return new Dimension(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics aGraphics, JComponent aComponent) {
        ChannelLabelsView view = (ChannelLabelsView)aComponent;
        ChannelLabelsViewModel model = view.getModel();
        if (!model.hasData()) {
            return;
        }
        Graphics2D canvas = (Graphics2D)aGraphics.create();
        try {
            Rectangle clip = canvas.getClipBounds();
            IUIElement[] elements = model.getSignalElements(clip.y, clip.height);
            if (elements.length == 0) {
                return;
            }
            canvas.setRenderingHints(ChannelLabelsUI.createRenderingHints());
            canvas.setBackground(model.getBackgroundColor());
            canvas.clearRect(clip.x, clip.y, clip.width, clip.height);
            int compWidth = view.getWidth() - model.getGutterWidth();
            int spacingY = model.getSignalElementSpacing();
            canvas.translate(0, elements[0].getYposition());
            for (IUIElement element : elements) {
                if (element instanceof ElementGroup) {
                    this.paintGroupLabel(canvas, model, (ElementGroup)element, compWidth);
                } else if (element instanceof SignalElement) {
                    this.paintBackground(canvas, model, (SignalElement)element, compWidth);
                    this.paintSignalLabel(canvas, model, (SignalElement)element, compWidth);
                }
                canvas.translate(0, element.getHeight() + spacingY);
            }
        }
        finally {
            canvas.dispose();
            canvas = null;
        }
    }

    private void drawLabel(Graphics2D aCanvas, ChannelLabelsViewModel aModel, String aText, Color aColor, int aXpos, int aYpos) {
        if (aModel.isDrawTextShadow()) {
            aCanvas.setColor(aModel.getTextShadowColor());
            aCanvas.drawString(aText, aXpos + 2, aYpos + 2);
        }
        aCanvas.setColor(aColor);
        aCanvas.drawString(aText, aXpos, aYpos);
    }

    private boolean isSelectedElement(IUIElement aElement, ChannelLabelsViewModel aModel) {
        if (!(aElement instanceof SignalElement)) {
            return false;
        }
        SignalElement signalElement = (SignalElement)aElement;
        return signalElement.isDigitalSignal() && aModel.getSelectedChannelIndex() == signalElement.getChannel().getIndex();
    }

    private void paintBackground(Graphics2D aCanvas, ChannelLabelsViewModel aModel, SignalElement aElement, int aWidth) {
        int arcWidth = aModel.getArcWidth();
        int x = -arcWidth;
        boolean y = false;
        int width = aWidth + arcWidth;
        int height = aElement.getHeight();
        Color color1 = aModel.getLabelGradientColor1();
        Color color2 = aModel.getLabelGradientColor2();
        if (this.isSelectedElement(aElement, aModel)) {
            color2 = ColorUtils.getHighlightColor((Color)color2, (float)2.0f);
        }
        GradientPaint paint = new GradientPaint(x, -5.0f, color2, x, height + 7, color1);
        Paint oldPaint = aCanvas.getPaint();
        aCanvas.setPaint(paint);
        aCanvas.fillRoundRect(x, 0, width, height, arcWidth, arcWidth);
        aCanvas.setPaint(oldPaint);
        aCanvas.setColor(aElement.getColor());
        aCanvas.drawRoundRect(x, 0, width, height, arcWidth, arcWidth);
    }

    private void paintSignalLabel(Graphics2D aCanvas, ChannelLabelsViewModel aModel, SignalElement aElement, int aWidth) {
        String label = aElement.getLabel();
        int aHeight = aElement.getHeight();
        boolean highlight = false;
        Color labelColor = aModel.getSignalLabelForegroundColor();
        String index = "";
        if (aElement.isDigitalSignal() && aModel.isShowChannelIndex()) {
            index = Integer.toString(aElement.getChannel().getIndex());
        }
        highlight = this.isSelectedElement(aElement, aModel);
        boolean labelDefined = label != null && !"".equals(label.trim());
        boolean indexDefined = index != null && !"".equals(index.trim());
        int padding = aModel.getHorizontalPadding();
        double middle = (double)aHeight / 2.0;
        if (labelDefined) {
            Font labelFont = aModel.getLabelFont();
            FontMetrics labelFm = aCanvas.getFontMetrics(labelFont);
            Rectangle2D labelBounds = labelFm.getStringBounds(label, aCanvas);
            int labelXpos = (int)((double)aWidth - labelBounds.getWidth() - (double)padding);
            int labelYpos = !indexDefined ? (int)(middle - labelBounds.getCenterY()) : (int)(middle - (double)labelFm.getDescent());
            if (highlight) {
                labelColor = ColorUtils.getHighlightColor((Color)labelColor, (float)2.0f);
            }
            aCanvas.setFont(labelFont);
            this.drawLabel(aCanvas, aModel, label, labelColor, labelXpos, labelYpos);
        }
        if (indexDefined) {
            Font indexFont = aModel.getIndexFont();
            FontMetrics indexFm = aCanvas.getFontMetrics(indexFont);
            Rectangle2D indexBounds = indexFm.getStringBounds(index, aCanvas);
            int indexXpos = (int)((double)aWidth - indexBounds.getWidth() - (double)padding);
            int indexYpos = !labelDefined ? (int)Math.round(middle + indexBounds.getCenterY()) : (int)Math.round(middle + (double)indexFm.getAscent());
            aCanvas.setFont(indexFont);
            this.drawLabel(aCanvas, aModel, index, aModel.getIndexForegroundColor(), indexXpos, indexYpos);
        }
    }

    private void paintGroupLabel(Graphics2D aCanvas, ChannelLabelsViewModel aModel, ElementGroup aElement, int aWidth) {
        String label = aElement.getLabel();
        int aHeight = aElement.getHeight();
        Color labelColor = aModel.getGroupLabelForegroundColor();
        boolean highlight = aElement.getDigitalSignalByChannelIndex(aModel.getSelectedChannelIndex()) != null;
        boolean labelDefined = label != null && !"".equals(label.trim());
        int padding = aModel.getHorizontalPadding();
        if (labelDefined) {
            Font labelFont = aModel.getLabelFont();
            FontMetrics labelFm = aCanvas.getFontMetrics(labelFont);
            Rectangle2D labelBounds = labelFm.getStringBounds(label, aCanvas);
            int labelXpos = padding;
            int labelYpos = (int)((double)aHeight - labelBounds.getMaxY());
            if (highlight) {
                labelColor = ColorUtils.getHighlightColor((Color)labelColor, (float)2.0f);
            }
            aCanvas.setFont(labelFont);
            this.drawLabel(aCanvas, aModel, label, labelColor, labelXpos, labelYpos);
        }
    }
}

