/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.model;

import java.awt.Color;
import java.awt.Point;
import javax.swing.UIManager;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.IUIElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElementManager;
import nl.lxtreme.ols.client.signaldisplay.util.CursorFlagTextFormatter;
import nl.lxtreme.ols.util.ColorUtils;

public abstract class AbstractViewModel {
    protected final SignalDiagramController controller;
    private final CursorFlagTextFormatter cursorFlagRender;

    protected AbstractViewModel(SignalDiagramController aController) {
        this.controller = aController;
        this.cursorFlagRender = new CursorFlagTextFormatter(this.controller.getSignalDiagramModel());
    }

    public Color getCursorColor(int aCursorIndex) {
        Cursor cursor = this.getSignalDiagramModel().getCursor(aCursorIndex);
        return cursor.getColor();
    }

    public String getCursorFlagText(int aCursorIndex, CursorFlagTextFormatter.LabelStyle aStyle) {
        Cursor cursor = this.getSignalDiagramModel().getCursor(aCursorIndex);
        return this.cursorFlagRender.getCursorFlagText(cursor, aStyle);
    }

    public int getCursorScreenCoordinate(int aCursorIndex) {
        Cursor cursorTimestamp = this.getSignalDiagramModel().getCursor(aCursorIndex);
        if (!cursorTimestamp.isDefined()) {
            return -1;
        }
        return this.timestampToCoordinate(cursorTimestamp.getTimestamp());
    }

    public Color getCursorTextColor(int aCursorIndex) {
        return ColorUtils.getContrastColor((Color)this.getCursorColor(aCursorIndex));
    }

    public int getSelectedChannelIndex() {
        return this.getSignalDiagramModel().getSelectedChannelIndex();
    }

    public final SignalElementManager getSignalElementManager() {
        return this.getSignalDiagramModel().getSignalElementManager();
    }

    public IUIElement[] getSignalElements(int aY, int aHeight) {
        return this.getSignalElementManager().getUIElements(aY, aHeight, SignalElementManager.SignalElementMeasurer.LOOSE_MEASURER);
    }

    public int getSignalElementSpacing() {
        return UIManager.getInt("ols.signal.element.spacer.height");
    }

    public Color getTriggerColor() {
        Color color = UIManager.getColor("ols.signal.trigger.color");
        if (color == null) {
            color = Color.WHITE;
        }
        return color;
    }

    public long getTriggerOffset() {
        Long triggerPosition = this.getSignalDiagramModel().getTriggerPosition();
        if (triggerPosition == null) {
            return 0L;
        }
        return triggerPosition;
    }

    public double getZoomFactor() {
        return this.getSignalDiagramModel().getZoomFactor();
    }

    public final boolean hasData() {
        return this.getSignalDiagramModel().hasData();
    }

    public boolean hasTriggerData() {
        return this.getSignalDiagramModel().getTriggerPosition() != null;
    }

    public boolean isCursorMode() {
        return this.getSignalDiagramModel().isCursorMode();
    }

    public boolean isMeasurementMode() {
        return this.getSignalDiagramModel().isMeasurementMode();
    }

    public int timestampToCoordinate(long aTimestamp) {
        double result = this.getSignalDiagramModel().getZoomFactor() * (double)aTimestamp;
        if (result > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)result;
    }

    protected final SignalDiagramModel getSignalDiagramModel() {
        return this.controller.getSignalDiagramModel();
    }

    protected int locationToSampleIndex(Point aPoint) {
        SignalDiagramModel model = this.controller.getSignalDiagram().getModel();
        return model.locationToSampleIndex(aPoint);
    }
}

