/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.model;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.UIManager;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.model.AbstractViewModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ElementGroup;
import nl.lxtreme.ols.client.signaldisplay.signalelement.IUIElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElementManager;

public class ChannelLabelsViewModel
extends AbstractViewModel {
    public ChannelLabelsViewModel(SignalDiagramController aController) {
        super(aController);
    }

    public boolean acceptDrop(IUIElement aMovedElement, IUIElement aInsertPoint) {
        boolean result = false;
        if (aMovedElement != null && aMovedElement instanceof SignalElement && aInsertPoint != null) {
            result = true;
        }
        return result;
    }

    public IUIElement findUIElement(Point aCoordinate) {
        return this.getSignalDiagramModel().findUIElement(aCoordinate);
    }

    public int findUIElementVirtualOffset(Point aCoordinate) {
        IUIElement signalElement = this.findUIElement(aCoordinate);
        if (signalElement != null) {
            int spacing = UIManager.getInt("ols.signal.element.spacer.height") / 2;
            return signalElement.getYposition() + signalElement.getHeight() + spacing;
        }
        return -1;
    }

    public final Collection<Channel> getAllChannels() {
        Collection<SignalElement> allElements = this.getSignalElementManager().getAllElements();
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (SignalElement element : allElements) {
            if (!element.isDigitalSignal()) continue;
            channels.add(element.getChannel());
        }
        return channels;
    }

    public int getArcWidth() {
        return UIManager.getInt("ols.channellabels.arc.width");
    }

    public Color getBackgroundColor() {
        Color color = UIManager.getColor("ols.channellabels.background.color");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public Color getGroupLabelForegroundColor() {
        Color color = UIManager.getColor("ols.channellabels.grouplabel.foreground.color");
        if (color == null) {
            color = Color.WHITE;
        }
        return color;
    }

    public int getGutterWidth() {
        return UIManager.getInt("ols.channellabels.gutter.width");
    }

    public int getHorizontalPadding() {
        return UIManager.getInt("ols.channellabels.label.padding");
    }

    public Font getIndexFont() {
        Font font = UIManager.getFont("ols.channellabels.index.font");
        if (font == null) {
            Font labelFont = this.getLabelFont();
            font = labelFont.deriveFont(0.75f * labelFont.getSize2D());
        }
        return font;
    }

    public Color getIndexForegroundColor() {
        Color color = UIManager.getColor("ols.channellabels.index.color");
        if (color == null) {
            color = Color.WHITE;
        }
        return color;
    }

    public Font getLabelFont() {
        Font font = UIManager.getFont("ols.channellabels.label.font");
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return font;
    }

    public Color getLabelGradientColor1() {
        Color color = UIManager.getColor("ols.channellabels.label.gradient.1.color");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public Color getLabelGradientColor2() {
        Color color = UIManager.getColor("ols.channellabels.label.gradient.2.color");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public int getMinimalWidth() {
        return UIManager.getInt("ols.channellabels.minimal.width");
    }

    public int getPreferredHeight() {
        return this.controller.getSignalDiagram().getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreferredWidth() {
        int minWidth = 0;
        BufferedImage dummy = new BufferedImage(1, 1, 2);
        Graphics2D canvas = dummy.createGraphics();
        int padding = 2 * this.getHorizontalPadding() + this.getGutterWidth();
        try {
            FontMetrics fm = canvas.getFontMetrics(this.getLabelFont());
            for (SignalElement element : this.getSignalElementManager().getAllElements()) {
                String label = element.getLabel();
                if (label == null) {
                    label = "";
                }
                minWidth = Math.max(minWidth, fm.stringWidth(label) + padding);
            }
        }
        finally {
            canvas.dispose();
            canvas = null;
            dummy = null;
        }
        minWidth = Math.max(minWidth, this.getMinimalWidth());
        return minWidth;
    }

    public Color getSignalLabelForegroundColor() {
        Color color = UIManager.getColor("ols.channellabels.label.foreground.color");
        if (color == null) {
            color = Color.WHITE;
        }
        return color;
    }

    public Color getTextShadowColor() {
        Color color = UIManager.getColor("ols.channellabels.shadow.color");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public boolean isDrawTextShadow() {
        return UIManager.getBoolean("ols.channellabels.shadow.boolean");
    }

    public boolean isShowChannelIndex() {
        return UIManager.getBoolean("ols.channellabels.show.channel.index.boolean");
    }

    public void moveSignalElement(SignalElement aMovedElement, IUIElement aInsertElement) {
        int newIndex;
        SignalElementManager channelGroupManager = this.getSignalElementManager();
        ElementGroup oldGroup = aMovedElement.getGroup();
        ElementGroup newGroup = aInsertElement.getGroup();
        if (aInsertElement instanceof SignalElement) {
            SignalElement signalElement = (SignalElement)aInsertElement;
            int offset = oldGroup != newGroup ? 1 : 0;
            newIndex = signalElement.getVirtualIndex() + offset;
        } else {
            newIndex = newGroup.getElementCount();
        }
        channelGroupManager.moveElement(aMovedElement, newGroup, newIndex);
    }
}

