/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.model;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.client.signaldisplay.ICursorChangeListener;
import nl.lxtreme.ols.client.signaldisplay.IDataModelChangeListener;
import nl.lxtreme.ols.client.signaldisplay.IMeasurementListener;
import nl.lxtreme.ols.client.signaldisplay.MeasurementInfo;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.ZoomController;
import nl.lxtreme.ols.client.signaldisplay.signalelement.IUIElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElementManager;

public class SignalDiagramModel {
    private static final int SNAP_CURSOR_MODE = 1;
    private static final int MEASUREMENT_MODE = 2;
    private static final double TIMESTAMP_FACTOR = 100.0;
    private volatile int mode;
    private volatile int selectedChannelIndex;
    private volatile DataSet dataSet;
    private final ZoomController zoomController;
    private final SignalElementManager channelGroupManager;
    private final SignalDiagramController controller;
    private final EventListenerList eventListeners;
    private final PropertyChangeSupport propertyChangeSupport;

    public SignalDiagramModel(SignalDiagramController aController) {
        this.controller = aController;
        this.zoomController = new ZoomController(aController);
        this.channelGroupManager = new SignalElementManager();
        this.eventListeners = new EventListenerList();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.mode = 0;
        this.addDataModelChangeListener(this.channelGroupManager);
    }

    static final int binarySearch(long[] aArray, int aFromIndex, int aToIndex, long aKey) {
        int mid = -1;
        int low = aFromIndex;
        int high = aToIndex - 1;
        while (low <= high) {
            int c;
            mid = low + high >>> 1;
            long midVal = aArray[mid];
            int n = aKey < midVal ? -1 : (c = aKey == midVal ? 0 : 1);
            if (c > 0) {
                low = mid + 1;
                continue;
            }
            if (c < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (mid < 0) {
            return low;
        }
        if (mid < aToIndex - 1 && aKey > aArray[mid]) {
            return mid + 1;
        }
        return mid;
    }

    static final void shiftElements(int[] aInput, int aOldIdx, int aNewIdx) {
        int length = aInput.length;
        int moved = aInput[aOldIdx];
        System.arraycopy(aInput, aOldIdx + 1, aInput, aOldIdx, length - 1 - aOldIdx);
        System.arraycopy(aInput, aNewIdx, aInput, aNewIdx + 1, length - 1 - aNewIdx);
        aInput[aNewIdx] = moved;
    }

    public void addCursorChangeListener(ICursorChangeListener aListener) {
        this.eventListeners.add(ICursorChangeListener.class, aListener);
    }

    public void addDataModelChangeListener(IDataModelChangeListener aListener) {
        this.eventListeners.add(IDataModelChangeListener.class, aListener);
    }

    public void addMeasurementListener(IMeasurementListener aListener) {
        this.eventListeners.add(IMeasurementListener.class, aListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener aListener) {
        this.propertyChangeSupport.addPropertyChangeListener(aListener);
    }

    public final long findEdgeAfter(int aChannelIdx, long aTimestamp) {
        long[] timestamps = this.getTimestamps();
        int[] values = this.getValues();
        int refIdx = Arrays.binarySearch(timestamps, aTimestamp);
        if (refIdx < 0) {
            refIdx = -(refIdx + 1) - 1;
        }
        if (refIdx < 0 || refIdx >= values.length) {
            return timestamps[0];
        }
        int mask = 1 << aChannelIdx;
        int refValue = values[refIdx] & mask;
        while (++refIdx < values.length - 1 && (values[refIdx] & mask) == refValue) {
        }
        return timestamps[refIdx];
    }

    public final long findEdgeBefore(int aChannelIdx, long aTimestamp) {
        long[] timestamps = this.getTimestamps();
        int[] values = this.getValues();
        int refIdx = Arrays.binarySearch(timestamps, aTimestamp);
        if (refIdx < 0) {
            refIdx = -(refIdx + 1) - 1;
        }
        if (refIdx < 0 || refIdx >= values.length) {
            return timestamps[0];
        }
        int mask = 1 << aChannelIdx;
        int refValue = values[refIdx] & mask;
        while (--refIdx > 0 && (values[refIdx] & mask) == refValue) {
        }
        return timestamps[Math.max(0, refIdx)];
    }

    public IUIElement findUIElement(Point aPoint) {
        IUIElement[] elements = this.getSignalElementManager().getUIElements(aPoint.y, 1, SignalElementManager.SignalElementMeasurer.LOOSE_MEASURER);
        if (elements.length == 0) {
            return null;
        }
        return elements[0];
    }

    public void fireMeasurementEvent(MeasurementInfo aMeasurementInfo) {
        IMeasurementListener[] listeners;
        for (IMeasurementListener listener : listeners = (IMeasurementListener[])this.eventListeners.getListeners(IMeasurementListener.class)) {
            if (!listener.isListening()) continue;
            listener.handleMeasureEvent(aMeasurementInfo);
        }
    }

    public long getAbsoluteLength() {
        if (!this.hasData()) {
            return 0L;
        }
        AcquisitionResult capturedData = this.getCapturedData();
        return capturedData.getAbsoluteLength();
    }

    public AcquisitionResult getCapturedData() {
        if (this.dataSet == null) {
            return null;
        }
        return this.dataSet.getCapturedData();
    }

    public Cursor getCursor(int aCursorIdx) {
        Cursor[] cursors = this.dataSet.getCursors();
        if (aCursorIdx < 0 || aCursorIdx > cursors.length) {
            throw new IllegalArgumentException("Invalid cursor index!");
        }
        return cursors[aCursorIdx];
    }

    public Cursor[] getDefinedCursors() {
        ArrayList<Cursor> result = new ArrayList<Cursor>();
        if (this.hasData()) {
            for (Cursor c : this.dataSet.getCursors()) {
                if (!c.isDefined()) continue;
                result.add(c);
            }
        }
        return result.toArray(new Cursor[result.size()]);
    }

    public Double getDisplayedTimeInterval() {
        int width = this.controller.getSignalDiagram().getVisibleRect().width;
        if (!this.hasData()) {
            return null;
        }
        double result = this.hasTimingData() ? (double)width / (this.getZoomFactor() * (double)this.getSampleRate()) : (double)width / this.getZoomFactor();
        return result;
    }

    public int getHorizontalBlockIncrement(Rectangle aVisibleRect, int aDirection) {
        int blockIncr = 50;
        int firstVisibleSample = this.locationToSampleIndex(aVisibleRect.getLocation());
        int lastVisibleSample = this.locationToSampleIndex(new Point(aVisibleRect.x + aVisibleRect.width, 0));
        int lastSampleIdx = this.getSampleCount();
        int inc = 0;
        if (aDirection < 0) {
            if (firstVisibleSample >= 0) {
                inc = 50;
            }
        } else if (aDirection > 0 && lastVisibleSample < lastSampleIdx) {
            inc = 50;
        }
        return inc;
    }

    public int getMinimumHeight() {
        return this.getSignalElementManager().calculateScreenHeight();
    }

    public int getSampleRate() {
        AcquisitionResult capturedData = this.getCapturedData();
        if (capturedData == null) {
            return -1;
        }
        return this.getCapturedData().getSampleRate();
    }

    public int getSampleWidth() {
        AcquisitionResult capturedData = this.getCapturedData();
        if (capturedData == null) {
            return 0;
        }
        return capturedData.getChannels();
    }

    public int getSelectedChannelIndex() {
        return this.selectedChannelIndex;
    }

    public final SignalElementManager getSignalElementManager() {
        return this.channelGroupManager;
    }

    public final MeasurementInfo getSignalHover(Point aPoint) {
        IUIElement element = this.findUIElement(aPoint);
        if (!(element instanceof SignalElement) || !((SignalElement)element).isDigitalSignal()) {
            return null;
        }
        return this.getSignalHover(aPoint, (SignalElement)element);
    }

    public MeasurementInfo getSignalHover(Point aPoint, SignalElement aSignalElement) {
        if (!aSignalElement.isDigitalSignal()) {
            throw new IllegalArgumentException("Signal element must represent a digital channel!");
        }
        int refIdx = this.locationToSampleIndex(aPoint);
        double refTime = this.hasTimingData() ? this.getTimestamp(aPoint) : (double)refIdx;
        Channel channel = aSignalElement.getChannel();
        if (!channel.isEnabled()) {
            return new MeasurementInfo(aSignalElement, refTime);
        }
        long[] timestamps = this.getTimestamps();
        long ts = -1L;
        long tm = -1L;
        long te = -1L;
        long th = -1L;
        int[] values = this.getValues();
        if (refIdx >= 0 && refIdx < values.length) {
            int mask = channel.getMask();
            int refValue = values[refIdx] & mask;
            int idx = refIdx;
            while (--idx >= 0 && (values[idx] & mask) == refValue) {
            }
            int tm_idx = Math.max(0, idx + 1);
            long l = tm = tm_idx == 0 ? 0L : timestamps[tm_idx];
            while (--idx >= 0 && (values[idx] & mask) != refValue) {
            }
            int ts_idx = Math.max(0, idx + 1);
            ts = ts_idx == 0 ? 0L : timestamps[ts_idx];
            idx = refIdx;
            while (++idx < values.length && (values[idx] & mask) == refValue) {
            }
            int te_idx = Math.min(idx, timestamps.length - 1);
            te = te_idx == 0 ? 0L : timestamps[te_idx];
            th = (values[ts_idx] & mask) != 0 ? Math.abs(tm - ts) : Math.abs(te - tm);
        }
        MeasurementInfo result = this.hasTimingData() ? new MeasurementInfo(aSignalElement, ts, tm, te, th, refTime, this.getZoomFactor(), this.getSampleRate()) : new MeasurementInfo(aSignalElement, ts, tm, te, refTime, this.getZoomFactor(), this.getSampleRate());
        return result;
    }

    public Double getTimelinePixelsPerSecond() {
        if (!this.hasData() || !this.hasTimingData()) {
            return null;
        }
        return this.getZoomFactor() * (double)this.getSampleRate();
    }

    public Double getTimelineSecondsPerPixel() {
        Double pixelsPerSecond = this.getTimelinePixelsPerSecond();
        if (pixelsPerSecond == null) {
            return null;
        }
        return 1.0 / pixelsPerSecond;
    }

    public Double getTimelineUnitOfTime() {
        Double p = this.getTimelineSecondsPerPixel();
        if (p == null) {
            return null;
        }
        return Math.pow(10.0, Math.ceil(Math.log10(p)));
    }

    public double getTimestamp(long aAbsTimestamp) {
        double zoomFactor = this.getZoomFactor();
        double scaleFactor = 100.0 * zoomFactor;
        Long triggerPos = this.getTriggerPosition();
        if (triggerPos != null) {
            aAbsTimestamp -= triggerPos.longValue();
        }
        int sampleRate = Math.max(1, this.getSampleRate());
        return scaleFactor * (double)aAbsTimestamp / (scaleFactor * (double)sampleRate);
    }

    public double getTimestamp(Point aPoint) {
        double zoomFactor = this.getZoomFactor();
        double scaleFactor = 100.0 * zoomFactor;
        double x = (double)aPoint.x / zoomFactor;
        Long triggerPos = this.getTriggerPosition();
        if (triggerPos != null) {
            x -= (double)triggerPos.longValue();
        }
        if (!this.hasTimingData()) {
            return scaleFactor * x / scaleFactor;
        }
        return scaleFactor * x / (scaleFactor * (double)this.getSampleRate());
    }

    public int getTimestampIndex(long aValue) {
        AcquisitionResult capturedData = this.getCapturedData();
        if (capturedData == null) {
            return 0;
        }
        return capturedData.getSampleIndex(aValue);
    }

    public long[] getTimestamps() {
        AcquisitionResult capturedData = this.getCapturedData();
        if (capturedData == null) {
            return new long[0];
        }
        return capturedData.getTimestamps();
    }

    public Long getTriggerPosition() {
        AcquisitionResult capturedData = this.getCapturedData();
        if (capturedData == null || !capturedData.hasTriggerData()) {
            return null;
        }
        return capturedData.getTriggerPosition();
    }

    public int[] getValues() {
        AcquisitionResult capturedData = this.getCapturedData();
        if (capturedData == null) {
            return new int[0];
        }
        return capturedData.getValues();
    }

    public int getVerticalBlockIncrement(Dimension aViewDimensions, Rectangle aVisibleRect, int aDirection) {
        SignalElementManager.SignalElementMeasurer measurer = SignalElementManager.SignalElementMeasurer.LOOSE_MEASURER;
        SignalElementManager elemMgr = this.getSignalElementManager();
        IUIElement[] signalElements = elemMgr.getUIElements(aVisibleRect.y + 1, 1, measurer);
        if (signalElements.length == 0) {
            return 0;
        }
        int spacing = UIManager.getInt("ols.signal.element.spacer.height");
        int inc = 0;
        int yPos = signalElements[0].getYposition();
        if (aDirection > 0) {
            int height = signalElements[0].getHeight() + spacing;
            inc = height - (aVisibleRect.y - yPos);
            if (inc < 0) {
                inc = -inc;
            }
        } else if (aDirection < 0 && (inc = aVisibleRect.y - yPos) <= 0 && (signalElements = elemMgr.getUIElements(yPos - spacing, 1, measurer)).length > 0) {
            inc += signalElements[0].getHeight() + spacing;
        }
        return inc;
    }

    public final ZoomController getZoomController() {
        return this.zoomController;
    }

    public final double getZoomFactor() {
        return this.getZoomController().getFactor();
    }

    public final boolean hasData() {
        return this.dataSet != null && this.getCapturedData() != null;
    }

    public boolean hasTimingData() {
        AcquisitionResult captureData = this.getCapturedData();
        return captureData != null && captureData.hasTimingData();
    }

    public boolean isAnalogScopeDefaultVisible() {
        return UIManager.getBoolean("ols.analogscope.default.visible.boolean");
    }

    public boolean isCursorDefined(int aCursorIdx) {
        Cursor[] cursors = this.dataSet.getCursors();
        if (aCursorIdx < 0 || aCursorIdx > cursors.length) {
            throw new IllegalArgumentException("Invalid cursor index!");
        }
        return cursors[aCursorIdx].isDefined();
    }

    public boolean isCursorMode() {
        return this.dataSet != null && this.dataSet.isCursorsEnabled();
    }

    public boolean isGroupSummaryDefaultVisible() {
        return UIManager.getBoolean("ols.groupsummary.default.visible.boolean");
    }

    public boolean isMeasurementMode() {
        return (this.mode & 2) != 0;
    }

    public boolean isSnapCursorMode() {
        return (this.mode & 1) != 0;
    }

    public int locationToSampleIndex(Point aCoordinate) {
        long timestamp = this.locationToTimestamp(aCoordinate);
        int idx = this.getTimestampIndex(timestamp);
        if (idx < 0) {
            return -1;
        }
        int sampleCount = this.getSampleCount() - 1;
        if (idx > sampleCount) {
            return sampleCount;
        }
        return idx;
    }

    public long locationToTimestamp(Point aCoordinate) {
        long timestamp = (long)Math.ceil((double)aCoordinate.x / this.getZoomFactor());
        if (timestamp < 0L) {
            return -1L;
        }
        return timestamp;
    }

    public void removeCursor(int aCursorIdx) {
        ICursorChangeListener[] listeners;
        Cursor[] cursors = this.dataSet.getCursors();
        if (aCursorIdx < 0 || aCursorIdx > cursors.length) {
            throw new IllegalArgumentException("Invalid cursor index!");
        }
        Cursor cursor = cursors[aCursorIdx];
        if (!cursor.isDefined()) {
            return;
        }
        Cursor oldCursor = cursor.clone();
        cursor.clear();
        for (ICursorChangeListener listener : listeners = (ICursorChangeListener[])this.eventListeners.getListeners(ICursorChangeListener.class)) {
            listener.cursorRemoved(oldCursor);
        }
    }

    public void removeCursorChangeListener(ICursorChangeListener aListener) {
        this.eventListeners.remove(ICursorChangeListener.class, aListener);
    }

    public void removeDataModelChangeListener(IDataModelChangeListener aListener) {
        this.eventListeners.remove(IDataModelChangeListener.class, aListener);
    }

    public void removeMeasurementListener(IMeasurementListener aListener) {
        this.eventListeners.remove(IMeasurementListener.class, aListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener aListener) {
        this.propertyChangeSupport.removePropertyChangeListener(aListener);
    }

    public void setCursor(int aCursorIdx, long aTimestamp) {
        Cursor[] cursors = this.dataSet.getCursors();
        if (aCursorIdx < 0 || aCursorIdx > cursors.length) {
            throw new IllegalArgumentException("Invalid cursor index!");
        }
        Cursor cursor = cursors[aCursorIdx];
        Cursor oldCursor = cursor.clone();
        cursor.setTimestamp(aTimestamp);
        this.fireCursorChangeEvent("timestamp", oldCursor, cursor);
    }

    public void setCursorColor(int aCursorIdx, Color aColor) {
        Cursor[] cursors = this.dataSet.getCursors();
        if (aCursorIdx < 0 || aCursorIdx > cursors.length) {
            throw new IllegalArgumentException("Invalid cursor index!");
        }
        Cursor cursor = cursors[aCursorIdx];
        Cursor oldCursor = cursor.clone();
        cursor.setColor(aColor);
        this.fireCursorChangeEvent("color", oldCursor, cursor);
    }

    public void setCursorLabel(int aCursorIdx, String aLabel) {
        Cursor[] cursors = this.dataSet.getCursors();
        if (aCursorIdx < 0 || aCursorIdx > cursors.length) {
            throw new IllegalArgumentException("Invalid cursor index!");
        }
        Cursor cursor = cursors[aCursorIdx];
        Cursor oldCursor = cursor.clone();
        cursor.setLabel(aLabel);
        this.fireCursorChangeEvent("label", oldCursor, cursor);
    }

    public void setCursorMode(boolean aCursorMode) {
        ICursorChangeListener[] listeners;
        this.dataSet.setCursorsEnabled(aCursorMode);
        for (ICursorChangeListener listener : listeners = (ICursorChangeListener[])this.eventListeners.getListeners(ICursorChangeListener.class)) {
            if (aCursorMode) {
                listener.cursorsVisible();
                continue;
            }
            listener.cursorsInvisible();
        }
    }

    public void setDataModel(DataSet aDataSet) {
        IDataModelChangeListener[] listeners;
        if (aDataSet == null) {
            throw new IllegalArgumentException("Parameter DataSet cannot be null!");
        }
        this.dataSet = aDataSet;
        for (IDataModelChangeListener listener : listeners = (IDataModelChangeListener[])this.eventListeners.getListeners(IDataModelChangeListener.class)) {
            listener.dataModelChanged(aDataSet);
        }
    }

    public void setMeasurementMode(boolean aEnabled) {
        IMeasurementListener[] listeners;
        this.mode = aEnabled ? (this.mode |= 2) : (this.mode &= 0xFFFFFFFD);
        for (IMeasurementListener listener : listeners = (IMeasurementListener[])this.eventListeners.getListeners(IMeasurementListener.class)) {
            if (aEnabled) {
                listener.enableMeasurementMode();
                continue;
            }
            listener.disableMeasurementMode();
        }
    }

    public void setSelectedChannelIndex(int aChannelIndex) {
        this.selectedChannelIndex = aChannelIndex;
    }

    public void setSnapCursorMode(boolean aSnapCursors) {
        this.mode = aSnapCursors ? (this.mode |= 1) : (this.mode &= 0xFFFFFFFE);
    }

    private void fireCursorChangeEvent(String aPropertyName, Cursor aOldCursor, Cursor aCursor) {
        ICursorChangeListener[] listeners;
        for (ICursorChangeListener listener : listeners = (ICursorChangeListener[])this.eventListeners.getListeners(ICursorChangeListener.class)) {
            if (!aOldCursor.isDefined()) {
                listener.cursorAdded(aCursor);
                continue;
            }
            listener.cursorChanged(aPropertyName, aOldCursor, aCursor);
        }
    }

    private int getSampleCount() {
        return this.getValues().length;
    }

    public static enum SignalAlignment {
        TOP,
        CENTER,
        BOTTOM;

    }
}

