/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.model;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.UIManager;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.model.AbstractViewModel;

public class TimeLineViewModel
extends AbstractViewModel {
    public TimeLineViewModel(SignalDiagramController aController) {
        super(aController);
    }

    public Color getBackgroundColor() {
        Color color = UIManager.getColor("ols.timeline.background.color");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public Font getCursorFlagFont() {
        Font font = UIManager.getFont("ols.timeline.cursor.font");
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return font;
    }

    public double getEndTimestamp(Rectangle aClip) {
        double zf = this.getZoomFactor();
        return (double)(aClip.x + aClip.width) / zf;
    }

    public Color getMajorTickColor() {
        Color color = UIManager.getColor("ols.timeline.majortick.color");
        if (color == null) {
            color = Color.LIGHT_GRAY;
        }
        return color;
    }

    public int getMajorTickHeight() {
        return UIManager.getInt("ols.timeline.majortick.height");
    }

    public Font getMajorTickLabelFont() {
        Font font = UIManager.getFont("ols.timeline.majortick.label.font");
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return font;
    }

    public Color getMinorTickColor() {
        Color color = UIManager.getColor("ols.timeline.minortick.color");
        if (color == null) {
            color = Color.DARK_GRAY;
        }
        return color;
    }

    public int getMinorTickHeight() {
        return UIManager.getInt("ols.timeline.minortick.height");
    }

    public Font getMinorTickLabelFont() {
        Font font = UIManager.getFont("ols.timeline.minortick.label.font");
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return font;
    }

    public double getPixelsPerSecond() {
        Double value = this.getSignalDiagramModel().getTimelinePixelsPerSecond();
        if (value == null) {
            return 1.0;
        }
        return value;
    }

    public int getPreferredHeight() {
        return UIManager.getInt("ols.timeline.height");
    }

    public int getPreferredWidth() {
        return this.controller.getSignalDiagram().getWidth();
    }

    public int getSampleRate() {
        return this.getSignalDiagramModel().getSampleRate();
    }

    public double getSecondsPerPixel() {
        Double value = this.getSignalDiagramModel().getTimelineSecondsPerPixel();
        if (value == null) {
            return 1.0;
        }
        return value;
    }

    public double getStartTimestamp(Rectangle aClip) {
        double zf = this.getZoomFactor();
        return (double)aClip.x / zf;
    }

    public Color getTextColor() {
        Color color = UIManager.getColor("ols.timeline.text.color");
        if (color == null) {
            color = Color.WHITE;
        }
        return color;
    }

    public Color getTextShadowColor() {
        Color color = UIManager.getColor("ols.timeline.text.shadow.color");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public Color getTickColor() {
        Color color = UIManager.getColor("ols.timeline.tick.color");
        if (color == null) {
            color = Color.DARK_GRAY;
        }
        return color;
    }

    public int getTickHeight() {
        return UIManager.getInt("ols.timeline.tick.height");
    }

    public double getUnitOfTime() {
        Double timelineUnitOfTime = this.getSignalDiagramModel().getTimelineUnitOfTime();
        if (timelineUnitOfTime == null) {
            return 1.0;
        }
        return timelineUnitOfTime;
    }

    public boolean hasTimingData() {
        return this.getSignalDiagramModel().hasTimingData();
    }

    public boolean isDrawTextShadow() {
        return UIManager.getBoolean("ols.timeline.text.shadow.boolean");
    }

    public boolean isMinorTimestampVisible() {
        return UIManager.getBoolean("ols.timeline.minortick.visible.boolean");
    }
}

