/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.signalelement;

import java.util.Collection;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.EventListenerList;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.client.signaldisplay.IDataModelChangeListener;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ElementGroup;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ISignalElementChangeListener;
import nl.lxtreme.ols.client.signaldisplay.signalelement.IUIElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElementModel;

public final class SignalElementManager
implements IDataModelChangeListener {
    private final AtomicReference<SignalElementModel> modelRef = new AtomicReference<SignalElementModel>(new SignalElementModel());
    private final EventListenerList eventListeners = new EventListenerList();

    public void addChannelChangeListener(ISignalElementChangeListener aListener) {
        this.eventListeners.add(ISignalElementChangeListener.class, aListener);
    }

    public int calculateScreenHeight() {
        return this.getSignalElementModel().calculateScreenHeight();
    }

    @Override
    public void dataModelChanged(DataSet aCapturedData) {
        SignalElementModel oldModel = this.getSignalElementModel();
        SignalElementModel newModel = new SignalElementModel();
        Channel[] newChannelList = aCapturedData.getChannels();
        if (oldModel == null || oldModel.getGroups().isEmpty()) {
            int groupCount = Math.max(1, (int)Math.ceil((double)newChannelList.length / 8.0));
            int channelsPerGroup = (int)Math.ceil((double)newChannelList.length / (double)groupCount);
            for (int g = 0; g < groupCount; ++g) {
                ElementGroup group = newModel.addGroup("Group " + (g + 1));
                for (int c = 0; c < channelsPerGroup; ++c) {
                    int channelIdx = g * channelsPerGroup + c;
                    if (newChannelList[channelIdx] == null) continue;
                    newModel.addSignalElement(group, SignalElement.createDigitalSignalElement(newChannelList[channelIdx], group));
                }
                newModel.addSignalElement(group, SignalElement.createGroupSummaryElement(group));
                newModel.addSignalElement(group, SignalElement.createAnalogScopeElement(group));
            }
        } else {
            HashSet<Integer> seenChannelIdxs = new HashSet<Integer>();
            ElementGroup newGroup = null;
            for (ElementGroup oldGroup : oldModel.getGroups()) {
                newGroup = newModel.addGroup(oldGroup.getName());
                for (SignalElement oldElement : oldGroup.getElements()) {
                    SignalElement element;
                    if (oldElement.isDigitalSignal()) {
                        int channelIdx = oldElement.getChannel().getIndex();
                        if (channelIdx >= newChannelList.length) continue;
                        Channel newChannel = newChannelList[channelIdx];
                        seenChannelIdxs.add(channelIdx);
                        element = SignalElement.createDigitalSignalElement(newChannel, newGroup);
                        element.setSignalAlignment(oldElement.getSignalAlignment());
                        element.setSignalHeight(oldElement.getSignalHeight());
                    } else if (oldElement.isAnalogSignal()) {
                        element = SignalElement.createAnalogScopeElement(newGroup);
                    } else if (oldElement.isGroupSummary()) {
                        element = SignalElement.createGroupSummaryElement(newGroup);
                    } else {
                        throw new RuntimeException("Unknown/unhandled signal element: " + oldElement);
                    }
                    element.setColor(oldElement.getColor());
                    element.setEnabled(oldElement.isEnabled());
                    element.setHeight(oldElement.getHeight());
                    element.setLabel(oldElement.getLabel());
                    newModel.addSignalElement(newGroup, element);
                }
            }
            if (newGroup == null) {
                newGroup = newModel.addGroup("Group 1");
            }
            for (Channel channel : newChannelList) {
                Integer channelIdx = channel.getIndex();
                if (seenChannelIdxs.contains(channelIdx)) continue;
                newModel.addSignalElement(newGroup, SignalElement.createDigitalSignalElement(channel, newGroup));
            }
        }
        this.setSignalElementModel(newModel);
    }

    public Collection<SignalElement> getAllElements() {
        SignalElementModel model = this.getSignalElementModel();
        return model.getAllElements();
    }

    public SortedSet<SignalElement> getAssignedElements() {
        SignalElementModel model = this.getSignalElementModel();
        return model.getAssignedElements();
    }

    public SignalElement getDigitalSignalByChannelIndex(int aChannelIndex) {
        SignalElementModel model = this.getSignalElementModel();
        return model.getDigitalSignalByChannelIndex(aChannelIndex);
    }

    public Collection<ElementGroup> getGroups() {
        SignalElementModel model = this.getSignalElementModel();
        return model.getGroups();
    }

    public IUIElement[] getUIElements(int aY, int aHeight, SignalElementMeasurer aMeasurer) {
        SignalElementModel model = this.getSignalElementModel();
        return model.getUIElements(aY, aHeight, aMeasurer);
    }

    public void moveElement(SignalElement aMovedElement, ElementGroup aNewGroup, int aNewIndex) {
        if (aMovedElement == null) {
            throw new IllegalArgumentException("Moved signal element cannot be null!");
        }
        if (aNewGroup == null) {
            throw new IllegalArgumentException("New group cannot be null!");
        }
        if (aNewIndex < 0 || aNewIndex > 32) {
            throw new IllegalArgumentException("Invalid new index: " + aNewIndex + "!");
        }
        ElementGroup oldCG = aMovedElement.getGroup();
        int oldIndex = aMovedElement.getVirtualIndex();
        aNewGroup.moveChannel(aMovedElement, aNewIndex);
        this.fireChannelMoveEvent(new ISignalElementChangeListener.ElementMoveEvent(aMovedElement, oldCG, oldIndex));
    }

    public void removeChannelChangeListener(ISignalElementChangeListener aListener) {
        this.eventListeners.remove(ISignalElementChangeListener.class, aListener);
    }

    final SignalElementModel createSignalElementModelCopy() {
        SignalElementModel currentModel = this.getSignalElementModel();
        return new SignalElementModel(currentModel);
    }

    final void fireChannelMoveEvent(ISignalElementChangeListener.ElementMoveEvent aEvent) {
        ISignalElementChangeListener[] listeners;
        for (ISignalElementChangeListener listener : listeners = (ISignalElementChangeListener[])this.eventListeners.getListeners(ISignalElementChangeListener.class)) {
            listener.signalElementMoved(aEvent);
        }
    }

    final void fireGroupStructureChangeEvent(Collection<SignalElement> aSignalElements) {
        ISignalElementChangeListener[] listeners;
        for (ISignalElementChangeListener listener : listeners = (ISignalElementChangeListener[])this.eventListeners.getListeners(ISignalElementChangeListener.class)) {
            listener.groupStructureChanged(aSignalElements);
        }
    }

    final SignalElementModel getSignalElementModel() {
        return this.modelRef.get();
    }

    final void setSignalElementModel(SignalElementModel aModel) {
        SignalElementModel oldModel;
        while (!this.modelRef.compareAndSet(oldModel = this.modelRef.get(), aModel)) {
        }
        this.fireGroupStructureChangeEvent(aModel.getAssignedElements());
    }

    private static class StrictChannelElementMeasurer
    implements SignalElementMeasurer {
        private StrictChannelElementMeasurer() {
        }

        @Override
        public boolean signalElementFits(int aYpos, int aHeight, int aMinY, int aMaxY) {
            return aYpos >= aMinY && aYpos <= aMaxY;
        }
    }

    private static class LooseChannelElementMeasurer
    implements SignalElementMeasurer {
        private LooseChannelElementMeasurer() {
        }

        @Override
        public boolean signalElementFits(int aYpos, int aHeight, int aMinY, int aMaxY) {
            int y1 = aYpos;
            int y2 = y1 + aHeight;
            return !(y1 < aMinY && y2 < aMinY || y1 > aMaxY && y2 > aMaxY);
        }
    }

    public static interface SignalElementMeasurer {
        public static final SignalElementMeasurer STRICT_MEASURER = new StrictChannelElementMeasurer();
        public static final SignalElementMeasurer LOOSE_MEASURER = new LooseChannelElementMeasurer();

        public boolean signalElementFits(int var1, int var2, int var3, int var4);
    }
}

