/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.signalelement;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ElementGroup;
import nl.lxtreme.ols.client.signaldisplay.signalelement.IUIElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElementManager;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElementModel;
import nl.lxtreme.ols.util.swing.JLxTreeTransferHandler;
import nl.lxtreme.ols.util.swing.StandardActionFactory;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public class SignalElementManagerView
extends JDialog
implements StandardActionFactory.StatusAwareCloseableDialog {
    private static final long serialVersionUID = 1L;
    private final SignalElementManager elementManager;
    private final SignalElementModel model;
    private volatile boolean dialogResult;
    private JButton addGroupButton;
    private JButton removeGroupButton;
    private JButton cancelButton;
    private JButton okButton;
    private JTree tree;

    public SignalElementManagerView(Window aParent, SignalElementManager aElementManager) {
        super(aParent, "Signal Group Management", Dialog.ModalityType.APPLICATION_MODAL);
        this.elementManager = aElementManager;
        this.model = this.elementManager.createSignalElementModelCopy();
        this.initDialog();
        this.buildDialog();
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean setDialogStatus(StandardActionFactory.DialogStatus aStatus) {
        this.dialogResult = aStatus == StandardActionFactory.DialogStatus.OK;
        return true;
    }

    public boolean showDialog() {
        this.dialogResult = false;
        this.setVisible(true);
        if (this.dialogResult) {
            this.elementManager.setSignalElementModel(this.model);
        }
        return this.dialogResult;
    }

    final void addNewGroup() {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        boolean groupSummaryVisibleByDefault = UIManager.getBoolean("ols.groupsummary.default.visible.boolean");
        boolean scopeVisibleByDefault = UIManager.getBoolean("ols.analogscope.default.visible.boolean");
        int groupCount = this.model.getGroups().size();
        String name = String.format("Group %d", groupCount + 1);
        ElementGroup newGroup = this.model.addGroup(name);
        newGroup.setVisible(true);
        SignalElement groupSummaryElement = SignalElement.createGroupSummaryElement(newGroup);
        groupSummaryElement.setEnabled(groupSummaryVisibleByDefault);
        newGroup.addElement(groupSummaryElement);
        SignalElement analogScopeElement = SignalElement.createAnalogScopeElement(newGroup);
        analogScopeElement.setEnabled(scopeVisibleByDefault);
        newGroup.addElement(analogScopeElement);
        ElementTreeNode rootNode = (ElementTreeNode)model.getRoot();
        ElementTreeNode groupNode = new ElementTreeNode(newGroup);
        rootNode.add(groupNode);
        groupNode.add(new ElementTreeNode(groupSummaryElement));
        groupNode.add(new ElementTreeNode(analogScopeElement));
        int index = rootNode.getIndex(groupNode);
        model.nodesWereInserted(rootNode, new int[]{index});
        model.nodeStructureChanged(groupNode);
        this.tree.expandRow(index);
    }

    final void removeSelectedGroup() {
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        ElementTreeNode rootNode = (ElementTreeNode)model.getRoot();
        for (TreePath selectionPath : selectionPaths) {
            ElementTreeNode treeNode = (ElementTreeNode)selectionPath.getLastPathComponent();
            if (!(treeNode.getUserObject() instanceof ElementGroup)) continue;
            ElementGroup elementGroup = (ElementGroup)treeNode.getUserObject();
            this.model.removeGroup(elementGroup);
            model.nodesWereRemoved(rootNode, new int[]{rootNode.getIndex(treeNode)}, new Object[]{treeNode});
        }
    }

    private void buildDialog() {
        JComponent buttonPane = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{this.addGroupButton, this.removeGroupButton, this.okButton, this.cancelButton});
        JScrollPane scrollPane = new JScrollPane(this.tree);
        SwingComponentUtils.setupWindowContentPane((Window)this, (Component)scrollPane, (Component)buttonPane, (JButton)this.cancelButton);
    }

    private DefaultMutableTreeNode createTree() {
        ElementTreeNode rootNode = new ElementTreeNode();
        for (ElementGroup group : this.model.getGroups()) {
            ElementTreeNode groupNode = new ElementTreeNode(group);
            rootNode.add(groupNode);
            for (SignalElement element : group.getElements()) {
                groupNode.add(new ElementTreeNode(element));
            }
        }
        return rootNode;
    }

    private void initDialog() {
        this.okButton = StandardActionFactory.createOkButton();
        this.cancelButton = StandardActionFactory.createCancelButton();
        this.addGroupButton = new JButton("Add group");
        this.addGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                SignalElementManagerView.this.addNewGroup();
            }
        });
        this.removeGroupButton = new JButton("Remove group");
        this.removeGroupButton.setEnabled(false);
        this.removeGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                SignalElementManagerView.this.removeSelectedGroup();
            }
        });
        this.tree = new JTree(this.createTree());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(true);
        this.tree.setDragEnabled(true);
        this.tree.setDropMode(DropMode.INSERT);
        this.tree.setTransferHandler((TransferHandler)new JLxTreeTransferHandler());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent aEvent) {
                boolean onlyGroupsSelected;
                JTree tree = (JTree)aEvent.getSource();
                TreePath[] selectionPaths = tree.getSelectionPaths();
                boolean bl = onlyGroupsSelected = selectionPaths != null && selectionPaths.length > 0;
                if (selectionPaths != null) {
                    for (TreePath selectionPath : selectionPaths) {
                        ElementTreeNode comp = (ElementTreeNode)selectionPath.getLastPathComponent();
                        onlyGroupsSelected &= comp.getUserObject() instanceof ElementGroup;
                    }
                }
                if (SignalElementManagerView.this.model.getGroups().size() <= 1) {
                    onlyGroupsSelected = false;
                }
                SignalElementManagerView.this.removeGroupButton.setEnabled(onlyGroupsSelected);
            }
        });
        ElementTreeRenderer cellRenderer = new ElementTreeRenderer();
        this.tree.setCellRenderer(cellRenderer);
        this.tree.setCellEditor(new ElementCellEditor(this.tree, cellRenderer));
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    static class ElementTreeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        ElementTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree aTree, Object aValue, boolean aSelected, boolean aExpanded, boolean aLeaf, int aRow, boolean aHasFocus) {
            Object value = aValue;
            if (value instanceof DefaultMutableTreeNode) {
                value = ((DefaultMutableTreeNode)value).getUserObject();
            }
            if (value instanceof ElementGroup) {
                ElementGroup elementGroup = (ElementGroup)value;
                value = elementGroup.getName();
            } else if (value instanceof SignalElement) {
                SignalElement signalElement = (SignalElement)value;
                value = signalElement.getLabel();
            }
            JLabel delegate = (JLabel)super.getTreeCellRendererComponent(aTree, value, aSelected, aExpanded, aLeaf, aRow, aHasFocus);
            return delegate;
        }
    }

    static class ElementTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private static final String ROOT_ID = new String("<root>");

        public ElementTreeNode() {
            super(ROOT_ID);
        }

        public ElementTreeNode(ElementGroup aGroup) {
            super(aGroup);
            this.setAllowsChildren(true);
        }

        public ElementTreeNode(ElementTreeNode aNode) {
            super(aNode.getUserObject());
            this.setAllowsChildren(aNode.allowsChildren);
        }

        public ElementTreeNode(SignalElement aElement) {
            super(aElement);
            this.setAllowsChildren(false);
        }

        public String getText() {
            String result = "";
            if (this.userObject instanceof ElementGroup) {
                result = ((ElementGroup)this.userObject).getName();
            } else if (this.userObject instanceof SignalElement) {
                result = ((SignalElement)this.userObject).getLabel();
            }
            return result;
        }

        @Override
        public void insert(MutableTreeNode aNewChild, int aChildIndex) {
            super.insert(aNewChild, aChildIndex);
            Object newChildUserObject = ((ElementTreeNode)aNewChild).getUserObject();
            if (this.userObject instanceof ElementGroup && newChildUserObject instanceof SignalElement) {
                ((ElementGroup)this.userObject).moveChannel((SignalElement)newChildUserObject, aChildIndex);
            }
        }

        public boolean isVisible() {
            boolean result = false;
            if (this.userObject instanceof ElementGroup) {
                result = ((ElementGroup)this.userObject).isVisible();
            } else if (this.userObject instanceof SignalElement) {
                result = ((SignalElement)this.userObject).isEnabled();
            }
            return result;
        }

        @Override
        public void setParent(MutableTreeNode aNewParent) {
            if (this.parent == aNewParent) {
                return;
            }
            super.setParent(aNewParent);
        }

        public void setText(String aText) {
            if (this.userObject instanceof ElementGroup) {
                ((ElementGroup)this.userObject).setName(aText);
            } else if (this.userObject instanceof SignalElement) {
                ((SignalElement)this.userObject).setLabel(aText);
            }
        }

        @Override
        public void setUserObject(Object aUserObject) {
            if (aUserObject != ROOT_ID && aUserObject instanceof String) {
                this.setText((String)aUserObject);
            } else if (aUserObject instanceof Boolean) {
                this.setVisible((Boolean)aUserObject);
            } else if (aUserObject instanceof IUIElement) {
                super.setUserObject(aUserObject);
            }
        }

        public void setVisible(boolean aVisible) {
            if (this.userObject instanceof ElementGroup) {
                ((ElementGroup)this.userObject).setVisible(aVisible);
            } else if (this.userObject instanceof SignalElement) {
                ((SignalElement)this.userObject).setEnabled(aVisible);
            }
        }

        @Override
        public String toString() {
            return String.format("ElementTreeNode(%s)@%s", this.getUserObject(), Integer.toHexString(this.hashCode()));
        }
    }

    static class ElementCellEditor
    extends DefaultTreeCellEditor {
        public ElementCellEditor(JTree aTree, DefaultTreeCellRenderer aRenderer) {
            super(aTree, aRenderer);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree aTree, Object aValue, boolean aIsSelected, boolean aExpanded, boolean aLeaf, int aRow) {
            ElementTreeNode treeNode = (ElementTreeNode)aValue;
            return super.getTreeCellEditorComponent(aTree, treeNode.getText(), aIsSelected, aExpanded, aLeaf, aRow);
        }
    }
}

