/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.signalelement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.UIManager;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ElementGroup;
import nl.lxtreme.ols.client.signaldisplay.signalelement.IUIElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElementManager;

class SignalElementModel {
    private final List<ElementGroup> groups;
    private final List<SignalElement> elements;
    private final Object lock = new Object();

    public SignalElementModel() {
        this.groups = new ArrayList<ElementGroup>();
        this.elements = new ArrayList<SignalElement>();
    }

    public SignalElementModel(SignalElementModel aElementModel) {
        this.groups = new ArrayList<ElementGroup>();
        this.elements = new ArrayList<SignalElement>(aElementModel.elements.size());
        for (ElementGroup oldGroup : aElementModel.groups) {
            ElementGroup newGroup = new ElementGroup(oldGroup);
            this.groups.add(newGroup);
            this.elements.addAll(newGroup.getElements());
        }
    }

    public int calculateScreenHeight() {
        int height = 0;
        int spacing = UIManager.getInt("ols.signal.element.spacer.height");
        for (ElementGroup cg : this.getGroups()) {
            if (!cg.isVisible()) continue;
            height += cg.getHeight() + spacing;
            for (SignalElement element : cg.getElements()) {
                if (element.isDigitalSignal() && cg.isShowDigitalSignals()) {
                    height += element.getHeight() + spacing;
                    continue;
                }
                if (element.isGroupSummary() && cg.isShowGroupSummary()) {
                    height += element.getHeight() + spacing;
                    continue;
                }
                if (!element.isAnalogSignal() || !cg.isShowAnalogSignal()) continue;
                height += element.getHeight() + spacing;
            }
        }
        return height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SignalElement> getAllElements() {
        ArrayList<SignalElement> result = new ArrayList<SignalElement>();
        Object object = this.lock;
        synchronized (object) {
            if (this.elements != null) {
                result.addAll(this.elements);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<SignalElement> getAssignedElements() {
        TreeSet<SignalElement> channelIndexes = new TreeSet<SignalElement>();
        Object object = this.lock;
        synchronized (object) {
            for (ElementGroup cg : this.groups) {
                channelIndexes.addAll(cg.getElements());
            }
        }
        return channelIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignalElement getDigitalSignalByChannelIndex(int aChannelIndex) {
        SignalElement result = null;
        Object object = this.lock;
        synchronized (object) {
            ElementGroup cg;
            Iterator<ElementGroup> iterator = this.groups.iterator();
            while (iterator.hasNext() && (result = (cg = iterator.next()).getDigitalSignalByChannelIndex(aChannelIndex)) == null) {
            }
        }
        return result;
    }

    public ElementGroup getGroupByName(String aName) {
        if (aName == null || aName.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty!");
        }
        List<ElementGroup> groups = this.getGroups();
        for (ElementGroup group : groups) {
            if (!aName.equals(group.getName())) continue;
            return group;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ElementGroup> getGroups() {
        ArrayList<ElementGroup> result;
        List<ElementGroup> list = this.groups;
        synchronized (list) {
            result = new ArrayList<ElementGroup>(this.groups);
        }
        return Collections.unmodifiableList(result);
    }

    public IUIElement[] getUIElements(int aY, int aHeight, SignalElementManager.SignalElementMeasurer aMeasurer) {
        ArrayList<IUIElement> result = new ArrayList<IUIElement>();
        int yMin = aY;
        int yMax = aHeight + aY;
        int spacing = UIManager.getInt("ols.signal.element.spacer.height");
        int halfSpacing = spacing / 2;
        int yPos = 0;
        for (ElementGroup group : this.getGroups()) {
            if (!group.isVisible()) continue;
            if (yPos > yMax) break;
            int height = group.getHeight();
            if (aMeasurer.signalElementFits(yPos, height + halfSpacing, yMin, yMax)) {
                group.setYposition(yPos);
                result.add(group);
            }
            yPos += height + spacing;
            for (SignalElement element : group.getElements()) {
                if (element.isDigitalSignal() && group.isShowDigitalSignals()) {
                    height = element.getHeight();
                    if (aMeasurer.signalElementFits(yPos, height + halfSpacing, yMin, yMax)) {
                        element.setYposition(yPos);
                        result.add(element);
                    }
                    yPos += height + spacing;
                    continue;
                }
                if (element.isGroupSummary() && group.isShowGroupSummary()) {
                    height = element.getHeight();
                    if (aMeasurer.signalElementFits(yPos, height + halfSpacing, yMin, yMax)) {
                        element.setYposition(yPos);
                        result.add(element);
                    }
                    yPos += height + spacing;
                    continue;
                }
                if (!element.isAnalogSignal() || !group.isShowAnalogSignal()) continue;
                height = element.getHeight();
                if (aMeasurer.signalElementFits(yPos, height + halfSpacing, yMin, yMax)) {
                    element.setYposition(yPos);
                    result.add(element);
                }
                yPos += height + spacing;
            }
        }
        return result.toArray(new IUIElement[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ElementGroup addGroup(String aName) {
        ElementGroup result;
        Object object = this.lock;
        synchronized (object) {
            result = new ElementGroup(this.groups.size(), aName);
            this.groups.add(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSignalElement(ElementGroup aGroup, SignalElement aSignalElement) {
        if (aGroup == null) {
            throw new IllegalArgumentException("Group cannot be null!");
        }
        if (aSignalElement == null) {
            throw new IllegalArgumentException("Signal element cannot be null!");
        }
        if (aGroup.hasElement(aSignalElement)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.elements.contains(aSignalElement)) {
                this.elements.add(aSignalElement);
            }
            ElementGroup oldGroup = aSignalElement.getGroup();
            aGroup.addElement(aSignalElement);
            if (oldGroup != null && !oldGroup.hasElements()) {
                this.groups.remove(oldGroup);
            }
        }
    }

    protected List<SignalElement> getUnassignedElements() {
        ArrayList<SignalElement> channels = new ArrayList<SignalElement>(this.getAllElements());
        for (ElementGroup cg : this.getGroups()) {
            channels.removeAll(cg.getElements());
        }
        return channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeGroup(ElementGroup aGroup) {
        if (aGroup == null) {
            throw new IllegalArgumentException("Group cannot be null!");
        }
        List<ElementGroup> list = this.groups;
        synchronized (list) {
            if (this.groups.remove(aGroup)) {
                for (SignalElement element : aGroup.getElements()) {
                    aGroup.removeElement(element);
                }
            }
        }
    }

    protected void removeSignalElement(ElementGroup aGroup, SignalElement aSignalElement) {
        if (aGroup == null) {
            throw new IllegalArgumentException("Group cannot be null!");
        }
        if (aSignalElement == null) {
            throw new IllegalArgumentException("Signal element cannot be null!");
        }
        aGroup.removeElement(aSignalElement);
    }
}

