/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.util;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.api.data.annotation.Annotation;
import nl.lxtreme.ols.api.data.annotation.DataAnnotation;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;

public final class AnnotationsHelper {
    private final Channel channel;

    public AnnotationsHelper(Channel aChannel) {
        if (aChannel == null) {
            throw new IllegalArgumentException("Channel cannot be null!");
        }
        this.channel = aChannel;
    }

    public AnnotationsHelper(SignalElement aElement) {
        if (aElement == null) {
            throw new IllegalArgumentException("Element cannot be null!");
        }
        if (!aElement.isDigitalSignal()) {
            throw new IllegalArgumentException("Can only work for digital channels!");
        }
        this.channel = aElement.getChannel();
    }

    public DataAnnotation<?> getAnnotation(long aTimestamp) {
        DataAnnotation result = null;
        for (Annotation annotation : this.channel.getAnnotations()) {
            if (!(annotation instanceof DataAnnotation)) continue;
            DataAnnotation ann = (DataAnnotation)annotation;
            long annStartTime = ann.getStartTimestamp();
            long annEndTime = ann.getEndTimestamp();
            if (annStartTime > aTimestamp || annEndTime < aTimestamp) continue;
            result = ann;
            break;
        }
        return result;
    }

    public DataAnnotation<?> getAnnotationAfter(long aTimestamp) {
        TreeSet annotations = new TreeSet(this.channel.getAnnotations());
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof DataAnnotation)) continue;
            DataAnnotation ann = (DataAnnotation)annotation;
            long annStartTime = ann.getStartTimestamp();
            long annEndTime = ann.getEndTimestamp();
            if (annStartTime < aTimestamp || annEndTime < aTimestamp) continue;
            return ann;
        }
        return null;
    }

    public DataAnnotation<?> getAnnotationBefore(long aTimestamp) {
        DataAnnotation result = null;
        TreeSet annotations = new TreeSet(this.channel.getAnnotations());
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof DataAnnotation)) continue;
            DataAnnotation ann = (DataAnnotation)annotation;
            long annStartTime = ann.getStartTimestamp();
            long annEndTime = ann.getEndTimestamp();
            if (annStartTime >= aTimestamp || annEndTime >= aTimestamp) break;
            result = ann;
        }
        return result;
    }

    public <T extends DataAnnotation<?>> List<T> getAnnotations(Class<T> aType, long aStartTime, long aEndTime) {
        ArrayList<DataAnnotation> result = new ArrayList<DataAnnotation>();
        for (Annotation annotation : this.channel.getAnnotations()) {
            if (!aType.isAssignableFrom(annotation.getClass())) continue;
            DataAnnotation ann = (DataAnnotation)annotation;
            long annStartTime = ann.getStartTimestamp();
            long annEndTime = ann.getEndTimestamp();
            if (annStartTime < aStartTime && annEndTime < aStartTime || annStartTime > aEndTime && annEndTime > aEndTime) continue;
            result.add(ann);
        }
        return result;
    }

    public List<DataAnnotation> getDataAnnotations(long aStartTime, long aEndTime) {
        return this.getAnnotations(DataAnnotation.class, aStartTime, aEndTime);
    }
}

