/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.util;

import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.api.util.Unit;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;

public final class CursorFlagTextFormatter {
    private final SignalDiagramModel model;

    public CursorFlagTextFormatter(SignalDiagramModel aModel) {
        this.model = aModel;
    }

    public static String getCursorFlagText(SignalDiagramModel aModel, Cursor aCursor, LabelStyle aStyle) {
        return new CursorFlagTextFormatter(aModel).getCursorFlagText(aCursor, aStyle);
    }

    public String getCursorFlagText(Cursor aCursor, LabelStyle aStyle) {
        if (!aCursor.isDefined()) {
            return "";
        }
        double timestamp = this.model.getTimestamp(aCursor.getTimestamp());
        String timestampText = this.model.hasTimingData() ? Unit.Time.toUnit((double)timestamp).formatHumanReadable(timestamp) : "#" + (int)timestamp;
        Integer index = aCursor.getIndex() + 1;
        String label = aCursor.getLabel();
        if (!aCursor.hasLabel()) {
            label = index.toString();
        }
        switch (aStyle) {
            case LABEL_TIME: {
                return String.format("%s: %s", label, timestampText);
            }
            case INDEX_LABEL: {
                return String.format("%d: %s", index, label);
            }
            case TIME_ONLY: {
                return timestampText;
            }
            case LABEL_ONLY: {
                return label;
            }
        }
        return String.format("%d", index);
    }

    public static enum LabelStyle {
        INDEX_ONLY,
        TIME_ONLY,
        LABEL_ONLY,
        INDEX_LABEL,
        LABEL_TIME;

    }
}

