/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.view;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.action.EditSignalElementPropertiesAction;
import nl.lxtreme.ols.client.signaldisplay.dnd.ChannelTransferable;
import nl.lxtreme.ols.client.signaldisplay.dnd.DragAndDropLock;
import nl.lxtreme.ols.client.signaldisplay.dnd.DragAndDropTargetController;
import nl.lxtreme.ols.client.signaldisplay.laf.ChannelLabelsUI;
import nl.lxtreme.ols.client.signaldisplay.model.ChannelLabelsViewModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ElementGroup;
import nl.lxtreme.ols.client.signaldisplay.signalelement.IUIElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.util.GhostGlassPane;
import nl.lxtreme.ols.client.signaldisplay.view.AbstractMouseHandler;
import nl.lxtreme.ols.client.signaldisplay.view.AbstractViewLayer;
import nl.lxtreme.ols.client.signaldisplay.view.renderer.SignalElementInsertionPointRenderer;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public class ChannelLabelsView
extends AbstractViewLayer {
    private static final long serialVersionUID = 1L;
    static final Logger LOG = Logger.getLogger(ChannelLabelsView.class.getName());
    private final ChannelLabelsViewModel model;
    private final DropHandler dropHandler;
    private final DragAndDropListener dndListener;
    private final DragGestureRecognizer dragGestureRecognizer;
    private final ChannelLabelMouseHandler mouseHandler;

    private ChannelLabelsView(SignalDiagramController aController) {
        super(aController);
        this.model = new ChannelLabelsViewModel(aController);
        this.dropHandler = new DropHandler();
        this.dndListener = new DragAndDropListener();
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.addDragSourceMotionListener(this.dndListener);
        dragSource.addDragSourceListener(this.dndListener);
        this.dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(this, 2, this.dndListener);
        this.mouseHandler = new ChannelLabelMouseHandler(aController);
        this.updateUI();
    }

    public static ChannelLabelsView create(SignalDiagramController aController) {
        ChannelLabelsView result = new ChannelLabelsView(aController);
        return result;
    }

    @Override
    public void addNotify() {
        DragAndDropTargetController dndTargetController = this.getDnDTargetController();
        dndTargetController.addHandler(this.dropHandler);
        this.setDropTarget(new DropTarget(this, dndTargetController));
        this.addMouseListener(this.mouseHandler);
        super.addNotify();
    }

    public ChannelLabelsViewModel getModel() {
        return this.model;
    }

    @Override
    public void removeNotify() {
        this.getDnDTargetController().removeHandler(this.dropHandler);
        DragSource dragSource = this.dragGestureRecognizer.getDragSource();
        if (dragSource != null) {
            dragSource.removeDragSourceListener(this.dndListener);
            dragSource.removeDragSourceMotionListener(this.dndListener);
        }
        this.removeMouseListener(this.mouseHandler);
        super.removeNotify();
    }

    @Override
    public final void updateUI() {
        this.setUI(new ChannelLabelsUI());
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent aEvent) {
        if (!aEvent.isConsumed()) {
            MouseEvent event = this.convertEvent(aEvent);
            Point point = event.getPoint();
            this.getController().setSelectedChannel(point);
        }
        super.processMouseMotionEvent(aEvent);
    }

    private MouseEvent convertEvent(MouseEvent aEvent) {
        JComponent view = SwingComponentUtils.getDeepestComponentAt((MouseEvent)aEvent);
        return SwingUtilities.convertMouseEvent(aEvent.getComponent(), aEvent, view);
    }

    final class DropHandler
    implements DragAndDropTargetController.DragAndDropHandler {
        DropHandler() {
        }

        @Override
        public boolean acceptDrop(SignalDiagramController aController, DropTargetDropEvent aEvent) {
            boolean accepted = false;
            try {
                IUIElement insertElement;
                ChannelLabelsViewModel model;
                Transferable transferable = aEvent.getTransferable();
                SignalElement movedElement = (SignalElement)transferable.getTransferData(ChannelTransferable.CHANNEL_FLAVOR);
                if (movedElement != null && (accepted = (model = ChannelLabelsView.this.getModel()).acceptDrop(movedElement, insertElement = model.findUIElement(aEvent.getLocation())))) {
                    model.moveSignalElement(movedElement, insertElement);
                }
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Getting transfer data failed!", exception);
            }
            return accepted;
        }

        @Override
        public int getDropAction() {
            return 2;
        }

        @Override
        public DataFlavor getFlavor() {
            return ChannelTransferable.CHANNEL_FLAVOR;
        }
    }

    static final class DragAndDropListener
    implements DragGestureListener,
    DragSourceMotionListener,
    DragSourceListener {
        private final BufferedImage stubImage = new BufferedImage(1, 1, 2);

        private static Point createChannelDropPoint(Point aPoint, ChannelLabelsView aView, Component aTargetComponent) {
            ChannelLabelsViewModel model = aView.getModel();
            int offset = model.findUIElementVirtualOffset(aPoint);
            Point dropPoint = new Point(0, offset);
            SwingUtilities.convertPointToScreen(dropPoint, aView);
            SwingUtilities.convertPointFromScreen(dropPoint, aTargetComponent);
            return dropPoint;
        }

        private static GhostGlassPane getGlassPane(Component aComponent) {
            return (GhostGlassPane)SwingUtilities.getRootPane(aComponent).getGlassPane();
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent aEvent) {
            if (!DragAndDropLock.releaseLock(this)) {
                return;
            }
            GhostGlassPane glassPane = DragAndDropListener.getGlassPane(aEvent.getDragSourceContext().getComponent());
            glassPane.setVisible(false);
        }

        @Override
        public void dragEnter(DragSourceDragEvent aEvent) {
        }

        @Override
        public void dragExit(DragSourceEvent aEvent) {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent aEvent) {
            if (DragAndDropLock.isLocked(this) || !DragAndDropLock.obtainLock(this)) {
                return;
            }
            Point coordinate = (Point)aEvent.getDragOrigin().clone();
            ChannelLabelsView sourceComponent = (ChannelLabelsView)aEvent.getComponent();
            ChannelLabelsViewModel model = sourceComponent.getModel();
            IUIElement element = model.findUIElement(coordinate);
            if (element == null || element instanceof ElementGroup) {
                DragAndDropLock.releaseLock(this);
                return;
            }
            GhostGlassPane glassPane = DragAndDropListener.getGlassPane(sourceComponent);
            Point dropPoint = DragAndDropListener.createChannelDropPoint(coordinate, sourceComponent, glassPane);
            SignalElementInsertionPointRenderer renderer = new SignalElementInsertionPointRenderer(model, element);
            glassPane.setRenderer(renderer, dropPoint, coordinate);
            glassPane.setVisible(true);
            glassPane.repaintPartially();
            aEvent.startDrag(DragSource.DefaultMoveDrop, this.stubImage, new Point(0, 0), new ChannelTransferable(element), null);
        }

        @Override
        public void dragMouseMoved(DragSourceDragEvent aEvent) {
            Point coordinate = aEvent.getLocation();
            if (!DragAndDropLock.isLocked(this) || coordinate == null) {
                return;
            }
            DragSourceContext dragSourceContext = aEvent.getDragSourceContext();
            ChannelLabelsView sourceComponent = (ChannelLabelsView)dragSourceContext.getComponent();
            GhostGlassPane glassPane = DragAndDropListener.getGlassPane(sourceComponent);
            SwingUtilities.convertPointFromScreen(coordinate, sourceComponent);
            Point dropPoint = DragAndDropListener.createChannelDropPoint(coordinate, sourceComponent, glassPane);
            glassPane.updateRenderer(dropPoint, coordinate);
            glassPane.repaintPartially();
        }

        @Override
        public void dragOver(DragSourceDragEvent aEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent aEvent) {
        }
    }

    static final class ChannelLabelMouseHandler
    extends AbstractMouseHandler {
        public ChannelLabelMouseHandler(SignalDiagramController aController) {
            super(aController);
        }

        @Override
        public void mouseClicked(MouseEvent aEvent) {
            IUIElement element;
            this.getSignalDiagram().requestFocusInWindow();
            if (!aEvent.isConsumed() && aEvent.getClickCount() == 2 && (element = this.findSignalElement(aEvent.getPoint())) != null) {
                ActionEvent stubEvent = new ActionEvent(this, 1001, "");
                new EditSignalElementPropertiesAction(this.controller, element, aEvent.getLocationOnScreen()).actionPerformed(stubEvent);
                aEvent.consume();
            }
        }

        @Override
        public void mousePressed(MouseEvent aEvent) {
            if (this.handlePopupTrigger(aEvent)) {
                aEvent.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent aEvent) {
            if (this.handlePopupTrigger(aEvent)) {
                aEvent.consume();
            }
        }

        private JPopupMenu createChannelLabelPopup(Point aRelativePoint, Point aLocationOnScreen) {
            return this.popupHelper.createChannelLabelPopup(aRelativePoint, aLocationOnScreen);
        }

        private IUIElement findSignalElement(Point aPoint) {
            return this.controller.getSignalDiagramModel().findUIElement(aPoint);
        }

        private boolean handlePopupTrigger(MouseEvent aEvent) {
            JPopupMenu contextMenu;
            boolean result = false;
            if (aEvent.isPopupTrigger() && (contextMenu = this.createChannelLabelPopup(aEvent.getPoint(), aEvent.getLocationOnScreen())) != null) {
                contextMenu.show(aEvent.getComponent(), aEvent.getX(), aEvent.getY());
                result = true;
            }
            return result;
        }
    }
}

