/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.view;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import nl.lxtreme.ols.api.data.annotation.DataAnnotation;
import nl.lxtreme.ols.client.signaldisplay.ICursorChangeListener;
import nl.lxtreme.ols.client.signaldisplay.IMeasurementListener;
import nl.lxtreme.ols.client.signaldisplay.MeasurementInfo;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.laf.SignalUI;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.client.signaldisplay.model.SignalViewModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.IUIElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.util.AnnotationsHelper;
import nl.lxtreme.ols.client.signaldisplay.view.AbstractMouseHandler;
import nl.lxtreme.ols.client.signaldisplay.view.AbstractViewLayer;
import nl.lxtreme.ols.client.signaldisplay.view.ViewUtils;

public class SignalView
extends AbstractViewLayer
implements IMeasurementListener,
ICursorChangeListener {
    private static final long serialVersionUID = 1L;
    static final Cursor CURSOR_WAIT = Cursor.getPredefinedCursor(3);
    static final Cursor CURSOR_HOVER = Cursor.getPredefinedCursor(1);
    static final Cursor CURSOR_MOVE_CURSOR = Cursor.getPredefinedCursor(12);
    static final Cursor CURSOR_MOVE_TIMESTAMP = Cursor.getPredefinedCursor(11);
    private final SignalViewModel model;
    private final AbstractMouseHandler mouseHandler;

    private SignalView(SignalDiagramController aController) {
        super(aController);
        this.model = new SignalViewModel(aController);
        this.mouseHandler = new MouseHandler(aController);
        this.updateUI();
    }

    public static SignalView create(SignalDiagramController aController) {
        SignalView signalView = new SignalView(aController);
        aController.addCursorChangeListener(signalView);
        aController.addMeasurementListener(signalView);
        return signalView;
    }

    @Override
    public void addNotify() {
        this.updateUI();
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        super.addNotify();
    }

    @Override
    public void cursorAdded(nl.lxtreme.ols.api.data.Cursor aCursor) {
        int visibleHeight = this.getVisibleRect().height;
        SignalViewModel model = this.getModel();
        int cursorPos = model.timestampToCoordinate(aCursor.getTimestamp());
        this.repaint(new Rectangle(cursorPos - 1, 0, 2, visibleHeight));
    }

    @Override
    public void cursorChanged(String aPropertyName, nl.lxtreme.ols.api.data.Cursor aOldCursor, nl.lxtreme.ols.api.data.Cursor aNewCursor) {
        Rectangle visibleRect = this.getVisibleRect();
        int y = visibleRect.y;
        int height = visibleRect.height;
        SignalViewModel model = this.getModel();
        int cursorPos = model.timestampToCoordinate(aOldCursor.getTimestamp());
        this.repaint(0L, cursorPos - 1, y, 2, height);
        cursorPos = model.timestampToCoordinate(aNewCursor.getTimestamp());
        this.repaint(0L, cursorPos - 1, y, 2, height);
    }

    @Override
    public void cursorRemoved(nl.lxtreme.ols.api.data.Cursor aOldCursor) {
        int visibleHeight = this.getVisibleRect().height;
        SignalViewModel model = this.getModel();
        int cursorPos = model.timestampToCoordinate(aOldCursor.getTimestamp());
        this.repaint(0L, cursorPos - 1, 0, 2, visibleHeight);
    }

    @Override
    public void cursorsInvisible() {
        this.repaint(50L);
    }

    @Override
    public void cursorsVisible() {
        this.repaint(50L);
    }

    @Override
    public void disableMeasurementMode() {
        SignalUI signalUI = (SignalUI)this.ui;
        Rectangle oldRect = signalUI.getMeasurementRect();
        if (oldRect != null) {
            this.repaint(oldRect);
        }
    }

    @Override
    public void enableMeasurementMode() {
    }

    public SignalViewModel getModel() {
        return this.model;
    }

    @Override
    public void handleMeasureEvent(MeasurementInfo aEvent) {
        SignalUI signalUI = (SignalUI)this.ui;
        Rectangle oldRect = signalUI.getMeasurementRect();
        signalUI.handleMeasureEvent(aEvent);
        Rectangle newRect = signalUI.getMeasurementRect();
        if (aEvent != null) {
            this.setToolTipText(ViewUtils.getToolTipText(this.getSignalDiagramModel(), aEvent.getReferenceTime()));
        } else {
            this.setToolTipText(null);
        }
        if (oldRect != null) {
            this.repaint(oldRect);
        }
        if (newRect != null) {
            this.repaint(newRect);
        }
    }

    @Override
    public boolean isListening() {
        return ((SignalUI)this.ui).isListening();
    }

    @Override
    public void removeNotify() {
        this.removeMouseListener(this.mouseHandler);
        this.removeMouseMotionListener(this.mouseHandler);
        super.removeNotify();
    }

    @Override
    public final void updateUI() {
        this.setUI(new SignalUI());
    }

    private SignalDiagramModel getSignalDiagramModel() {
        return this.getController().getSignalDiagramModel();
    }

    private final class MouseHandler
    extends AbstractMouseHandler {
        private volatile MeasurementInfo lastMeasurementInfo;

        public MouseHandler(SignalDiagramController aController) {
            super(aController);
        }

        @Override
        public void mouseMoved(MouseEvent aEvent) {
            MouseEvent event = this.convertEvent(aEvent);
            Point point = event.getPoint();
            SignalDiagramModel model = this.getModel();
            this.controller.setSelectedChannel(point);
            if (model.isCursorMode() || model.isMeasurementMode()) {
                nl.lxtreme.ols.api.data.Cursor hoveredCursor;
                if (model.isMeasurementMode()) {
                    this.lastMeasurementInfo = model.getSignalHover(point);
                    if (this.lastMeasurementInfo != null) {
                        this.setMouseCursor(aEvent, CURSOR_HOVER);
                        model.fireMeasurementEvent(this.lastMeasurementInfo);
                        aEvent.consume();
                    }
                }
                if (model.isCursorMode() && (hoveredCursor = this.findCursor(point)) != null) {
                    this.setMouseCursor(aEvent, CURSOR_MOVE_CURSOR);
                    aEvent.consume();
                }
            }
            if (!aEvent.isConsumed()) {
                long timestamp;
                AnnotationsHelper helper;
                DataAnnotation<?> annotation;
                this.setMouseCursor(aEvent, null);
                SignalElement element = this.findDigitalSignal(point);
                if (element != null && (annotation = (helper = new AnnotationsHelper(element)).getAnnotation(timestamp = this.getModel().locationToTimestamp(point))) != null) {
                    SignalView view = (SignalView)aEvent.getSource();
                    view.setToolTipText(annotation.getAnnotation().toString());
                    aEvent.consume();
                }
            }
        }

        private SignalElement findDigitalSignal(Point aPoint) {
            IUIElement element = this.controller.getSignalDiagramModel().findUIElement(aPoint);
            if (element instanceof SignalElement && ((SignalElement)element).isDigitalSignal()) {
                return (SignalElement)element;
            }
            return null;
        }
    }
}

