/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.view;

import java.awt.Point;
import java.awt.event.MouseEvent;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.client.signaldisplay.ICursorChangeListener;
import nl.lxtreme.ols.client.signaldisplay.IDataModelChangeListener;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.laf.TimeLineUI;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.client.signaldisplay.model.TimeLineViewModel;
import nl.lxtreme.ols.client.signaldisplay.view.AbstractMouseHandler;
import nl.lxtreme.ols.client.signaldisplay.view.AbstractViewLayer;
import nl.lxtreme.ols.client.signaldisplay.view.SignalView;
import nl.lxtreme.ols.client.signaldisplay.view.ViewUtils;

public class TimeLineView
extends AbstractViewLayer
implements ICursorChangeListener,
IDataModelChangeListener {
    private static final long serialVersionUID = 1L;
    private final TimeLineViewModel model;
    private final MouseHandler mouseHandler;

    private TimeLineView(SignalDiagramController aController) {
        super(aController);
        this.model = new TimeLineViewModel(aController);
        this.mouseHandler = new MouseHandler(aController);
        this.updateUI();
    }

    public static TimeLineView create(SignalDiagramController aController) {
        TimeLineView result = new TimeLineView(aController);
        aController.addCursorChangeListener(result);
        aController.addDataModelChangeListener(result);
        return result;
    }

    @Override
    public void addNotify() {
        this.updateUI();
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        super.addNotify();
    }

    @Override
    public void cursorAdded(Cursor aCursor) {
        this.repaint(50L);
    }

    @Override
    public void cursorChanged(String aPropertyName, Cursor aOldCursor, Cursor aNewCursor) {
        this.repaint(50L);
    }

    @Override
    public void cursorRemoved(Cursor aOldCursor) {
        this.repaint(50L);
    }

    @Override
    public void cursorsInvisible() {
        this.repaint(50L);
    }

    @Override
    public void cursorsVisible() {
        this.repaint(50L);
    }

    @Override
    public void dataModelChanged(DataSet aDataSet) {
        this.repaint(50L);
    }

    public TimeLineViewModel getModel() {
        return this.model;
    }

    public int getTimeLineHeight() {
        return this.getModel().getPreferredHeight();
    }

    @Override
    public void removeNotify() {
        this.removeMouseListener(this.mouseHandler);
        this.removeMouseMotionListener(this.mouseHandler);
        this.removeMouseWheelListener(this.mouseHandler);
        super.removeNotify();
    }

    @Override
    public final void updateUI() {
        this.setUI(new TimeLineUI());
    }

    private final class MouseHandler
    extends AbstractMouseHandler {
        public MouseHandler(SignalDiagramController aController) {
            super(aController);
        }

        @Override
        public void mouseMoved(MouseEvent aEvent) {
            MouseEvent event = this.convertEvent(aEvent);
            Point point = event.getPoint();
            SignalDiagramModel model = this.getModel();
            if (model.isCursorMode()) {
                Cursor hoveredCursor = this.findCursor(point);
                if (hoveredCursor != null) {
                    this.setMouseCursor(aEvent, SignalView.CURSOR_MOVE_CURSOR);
                    aEvent.consume();
                } else {
                    this.setMouseCursor(aEvent, null);
                    aEvent.consume();
                }
            }
            TimeLineView.this.setToolTipText(ViewUtils.getToolTipText(this.getModel(), point));
        }
    }
}

